<?php
/**
 * Pro Features Comparison Page
 */

defined('ABSPATH') || exit;

// Check if pro is active
$is_pro_active = function_exists('kdsamref_is_pro_active') ? kdsamref_is_pro_active() : false;
?>

<div class="wrap kdsamref-pro-features-page">
    <!-- Hero Section -->
    <div class="kdsamref-hero-section">
        <div class="kdsamref-hero-content">
            <div class="kdsamref-hero-badge">
                <span class="kdsamref-badge-icon"><i class="fas fa-rocket"></i></span>
                <span><?php esc_html_e('Explore Products', 'kds-report-for-orderable'); ?></span>
            </div>
            <h1 class="kdsamref-hero-title">
                <?php esc_html_e('Upgrade your restaurant management', 'kds-report-for-orderable'); ?>
                <span class="kdsamref-hero-highlight"><?php esc_html_e('game', 'kds-report-for-orderable'); ?></span>
                <?php esc_html_e('with capabilities.', 'kds-report-for-orderable'); ?>
            </h1>
            <p class="kdsamref-hero-description">
                <?php esc_html_e('All-in-one restaurant management platform. Managing orders smartly, attracting customers efficiently.', 'kds-report-for-orderable'); ?>
            </p>
            <div class="kdsamref-hero-actions">
                <a href="https://codeon.ch/orderable-kds" target="_blank" rel="noopener" class="kdsamref-cta-primary">
                    <?php esc_html_e('Upgrade to Pro', 'kds-report-for-orderable'); ?>
                </a>
            </div>
        </div>
    </div>

    <!-- Features Section -->
    <div class="kdsamref-features-section">
        <div class="kdsamref-features-container">
            <!-- Left Column - Feature Cards -->
            <div class="kdsamref-features-sidebar">
                <div class="kdsamref-feature-card kdsamref-feature-card-active" data-feature="workflow">
                    <div class="kdsamref-feature-icon">
                        <div class="kdsamref-icon-bg kdsamref-icon-workflow">
                            <span class="kdsamref-icon-symbol"><i class="fas fa-cogs"></i></span>
                        </div>
                        <span class="kdsamref-icon-label"><?php esc_html_e('Workflow', 'kds-report-for-orderable'); ?></span>
                    </div>
                    <div class="kdsamref-feature-content">
                        <h3><?php esc_html_e('Advanced Workflow Management', 'kds-report-for-orderable'); ?></h3>
                        <p><?php esc_html_e('Streamline your kitchen process with custom steps and one-click status changes. Drag and drop to reorder workflow steps with visual progress indicators.', 'kds-report-for-orderable'); ?></p>
                        <span class="kdsamref-feature-arrow">→</span>
                    </div>
                </div>

                <div class="kdsamref-feature-card" data-feature="analytics">
                    <div class="kdsamref-feature-icon">
                        <div class="kdsamref-icon-bg kdsamref-icon-analytics">
                            <span class="kdsamref-icon-symbol"><i class="fas fa-chart-bar"></i></span>
                        </div>
                        <span class="kdsamref-icon-label"><?php esc_html_e('Analytics', 'kds-report-for-orderable'); ?></span>
                    </div>
                    <div class="kdsamref-feature-content">
                        <h3><?php esc_html_e('Advanced Analytics & Reports', 'kds-report-for-orderable'); ?></h3>
                        <p><?php esc_html_e('See revenue, net totals and tips by day with clean charts and tables. 6-month comparison to track trends and filter by categories.', 'kds-report-for-orderable'); ?></p>
                        <span class="kdsamref-feature-arrow">→</span>
                    </div>
                </div>

                <div class="kdsamref-feature-card" data-feature="realtime">
                    <div class="kdsamref-feature-icon">
                        <div class="kdsamref-icon-bg kdsamref-icon-realtime">
                            <span class="kdsamref-icon-symbol"><i class="fas fa-sync-alt"></i></span>
                        </div>
                        <span class="kdsamref-icon-label"><?php esc_html_e('Real-time', 'kds-report-for-orderable'); ?></span>
                    </div>
                    <div class="kdsamref-feature-content">
                        <h3><?php esc_html_e('Real-time Order Updates', 'kds-report-for-orderable'); ?></h3>
                        <p><?php esc_html_e('Auto-refresh system with smart notifications. Real-time order updates every 5-300 seconds with advanced notification system.', 'kds-report-for-orderable'); ?></p>
                        <span class="kdsamref-feature-arrow">→</span>
                    </div>
                </div>
            </div>

            <!-- Right Column - Feature Preview -->
            <div class="kdsamref-feature-preview">
                <div class="kdsamref-preview-card" id="workflow-preview">
                    <div class="kdsamref-preview-header">
                        <div class="kdsamref-preview-icon">
                            <span class="kdsamref-preview-symbol"><i class="fas fa-cogs"></i></span>
                        </div>
                        <span class="kdsamref-preview-label"><?php esc_html_e('WORKFLOW', 'kds-report-for-orderable'); ?></span>
                    </div>
                    <div class="kdsamref-preview-content">
                        <div class="kdsamref-order-preview">
                            <div class="kdsamref-order-avatar">
                                <div class="kdsamref-avatar-placeholder"><i class="fas fa-user"></i></div>
                            </div>
                            <div class="kdsamref-order-info">
                                <div class="kdsamref-order-name"><?php esc_html_e('Order #1234', 'kds-report-for-orderable'); ?></div>
                                <div class="kdsamref-order-email"><?php esc_html_e('Pizza Margherita', 'kds-report-for-orderable'); ?></div>
                            </div>
                            <div class="kdsamref-order-actions">
                                <button class="kdsamref-action-btn kdsamref-action-nurture">
                                    <span class="kdsamref-btn-icon"><i class="fas fa-envelope"></i></span>
                                    <?php esc_html_e('Process', 'kds-report-for-orderable'); ?>
                                </button>
                                <div class="kdsamref-stage-selector">
                                    <span class="kdsamref-stage-label"><?php esc_html_e('Stage:', 'kds-report-for-orderable'); ?></span>
                                    <select class="kdsamref-stage-dropdown">
                                        <option><?php esc_html_e('PREPARING', 'kds-report-for-orderable'); ?></option>
                                        <option><?php esc_html_e('COOKING', 'kds-report-for-orderable'); ?></option>
                                        <option><?php esc_html_e('READY', 'kds-report-for-orderable'); ?></option>
                                        <option><?php esc_html_e('COMPLETED', 'kds-report-for-orderable'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="kdsamref-preview-card" id="analytics-preview" style="display: none;">
                    <div class="kdsamref-preview-header">
                        <div class="kdsamref-preview-icon">
                            <span class="kdsamref-preview-symbol"><i class="fas fa-chart-bar"></i></span>
                        </div>
                        <span class="kdsamref-preview-label"><?php esc_html_e('ANALYTICS', 'kds-report-for-orderable'); ?></span>
                    </div>
                    <div class="kdsamref-preview-content">
                        <div class="kdsamref-chart-preview">
                            <div class="kdsamref-chart-placeholder">
                                <div class="kdsamref-chart-bars">
                                    <div class="kdsamref-bar" style="height: 60%;"></div>
                                    <div class="kdsamref-bar" style="height: 80%;"></div>
                                    <div class="kdsamref-bar" style="height: 45%;"></div>
                                    <div class="kdsamref-bar" style="height: 90%;"></div>
                                    <div class="kdsamref-bar" style="height: 70%;"></div>
                                </div>
                            </div>
                            <div class="kdsamref-chart-info">
                                <div class="kdsamref-chart-title"><?php esc_html_e('Daily Revenue', 'kds-report-for-orderable'); ?></div>
                                <div class="kdsamref-chart-value">€2,450</div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="kdsamref-preview-card" id="realtime-preview" style="display: none;">
                    <div class="kdsamref-preview-header">
                        <div class="kdsamref-preview-icon">
                            <span class="kdsamref-preview-symbol"><i class="fas fa-sync-alt"></i></span>
                        </div>
                        <span class="kdsamref-preview-label"><?php esc_html_e('REAL-TIME', 'kds-report-for-orderable'); ?></span>
                    </div>
                    <div class="kdsamref-preview-content">
                        <div class="kdsamref-realtime-preview">
                            <div class="kdsamref-realtime-indicator">
                                <div class="kdsamref-pulse-dot"></div>
                                <span><?php esc_html_e('Live Updates', 'kds-report-for-orderable'); ?></span>
                            </div>
                            <div class="kdsamref-realtime-stats">
                                <div class="kdsamref-stat-item">
                                    <span class="kdsamref-stat-label"><?php esc_html_e('Active Orders', 'kds-report-for-orderable'); ?></span>
                                    <span class="kdsamref-stat-value">12</span>
                                </div>
                                <div class="kdsamref-stat-item">
                                    <span class="kdsamref-stat-label"><?php esc_html_e('Last Update', 'kds-report-for-orderable'); ?></span>
                                    <span class="kdsamref-stat-value">2s ago</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Feature Comparison Section -->
    <div class="kdsamref-comparison-section">
        <div class="kdsamref-comparison-header">
            <h2><?php esc_html_e('Feature Comparison', 'kds-report-for-orderable'); ?></h2>
            <p><?php esc_html_e('See what you get with each version', 'kds-report-for-orderable'); ?></p>
        </div>

        <div class="kdsamref-comparison-table">
            <!-- Table Header -->
            <div class="kdsamref-comparison-row kdsamref-comparison-header-row">
                <div class="kdsamref-comparison-feature">
                    <h3><?php esc_html_e('Features', 'kds-report-for-orderable'); ?></h3>
                </div>
                <div class="kdsamref-comparison-free">
                    <div class="kdsamref-plan-badge kdsamref-plan-free">
                        <span class="kdsamref-plan-icon"><i class="fas fa-box"></i></span>
                        <span class="kdsamref-plan-name"><?php esc_html_e('Free', 'kds-report-for-orderable'); ?></span>
                    </div>
                </div>
                <div class="kdsamref-comparison-pro">
                    <div class="kdsamref-plan-badge kdsamref-plan-pro">
                        <span class="kdsamref-plan-icon"><i class="fas fa-rocket"></i></span>
                        <span class="kdsamref-plan-name"><?php esc_html_e('Pro', 'kds-report-for-orderable'); ?></span>
                    </div>
                </div>
            </div>

            <!-- Basic Features -->
            <div class="kdsamref-comparison-category">
                <h4><?php esc_html_e('Order Management', 'kds-report-for-orderable'); ?></h4>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Basic Order Management', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('View and manage orders', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Custom Order Statuses', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Create custom statuses', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Advanced Workflows', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Custom workflow steps with drag & drop', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-lock"><i class="fas fa-lock"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Unlimited Custom Statuses', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('No limits on custom statuses', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-lock"><i class="fas fa-lock"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <!-- Real-time Features -->
            <div class="kdsamref-comparison-category">
                <h4><?php esc_html_e('Real-time Features', 'kds-report-for-orderable'); ?></h4>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Manual Refresh', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Refresh orders manually', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Auto-Refresh System', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Real-time order updates (5-300 seconds)', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-lock"><i class="fas fa-lock"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Advanced Notifications', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Smart notification system', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-lock"><i class="fas fa-lock"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <!-- Analytics & Reports -->
            <div class="kdsamref-comparison-category">
                <h4><?php esc_html_e('Analytics & Reports', 'kds-report-for-orderable'); ?></h4>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Basic Dashboard', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Simple order dashboard', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Monthly Reports', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Revenue analytics and 6-month comparisons', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-lock"><i class="fas fa-lock"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Analytics Dashboard', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Detailed performance metrics', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-lock"><i class="fas fa-lock"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <!-- Integration & Support -->
            <div class="kdsamref-comparison-category">
                <h4><?php esc_html_e('Integration & Support', 'kds-report-for-orderable'); ?></h4>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('WooCommerce Integration', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Full WooCommerce compatibility', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('POS Integration', 'kds-report-for-orderable'); ?> <span style="color: #f59e0b; font-size: 12px;">(<?php esc_html_e('In Development', 'kds-report-for-orderable'); ?>)</span></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Point of sale system integration', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-lock"><i class="fas fa-lock"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Stock Management', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Track inventory and manage stock levels', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-lock"><i class="fas fa-lock"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Masonry Layout', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Advanced grid layout for better order organization', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-lock"><i class="fas fa-lock"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>

            <div class="kdsamref-comparison-row">
                <div class="kdsamref-comparison-feature">
                    <span class="kdsamref-feature-name"><?php esc_html_e('Priority Support', 'kds-report-for-orderable'); ?></span>
                    <span class="kdsamref-feature-desc"><?php esc_html_e('Premium customer support', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-comparison-free">
                    <span class="kdsamref-lock"><i class="fas fa-lock"></i></span>
                </div>
                <div class="kdsamref-comparison-pro">
                    <span class="kdsamref-check"><i class="fas fa-check"></i></span>
                </div>
            </div>
        </div>
    </div>

    <!-- Pro Advantages Section -->
    <div class="kdsamref-advantages-section">
        <div class="kdsamref-advantages-header">
            <h2><?php esc_html_e('Why Choose Pro?', 'kds-report-for-orderable'); ?></h2>
            <p><?php esc_html_e('Unlock the full potential of your restaurant management', 'kds-report-for-orderable'); ?></p>
        </div>

        <div class="kdsamref-advantages-grid">
            <div class="kdsamref-advantage-card">
                <div class="kdsamref-advantage-icon"><i class="fas fa-bolt"></i></div>
                <h3><?php esc_html_e('Performance', 'kds-report-for-orderable'); ?></h3>
                <p><?php esc_html_e('Faster loading and real-time updates for better efficiency', 'kds-report-for-orderable'); ?></p>
            </div>

            <div class="kdsamref-advantage-card">
                <div class="kdsamref-advantage-icon"><i class="fas fa-chart-line"></i></div>
                <h3><?php esc_html_e('Analytics', 'kds-report-for-orderable'); ?></h3>
                <p><?php esc_html_e('Detailed business insights and reports to grow your business', 'kds-report-for-orderable'); ?></p>
            </div>

            <div class="kdsamref-advantage-card">
                <div class="kdsamref-advantage-icon"><i class="fas fa-robot"></i></div>
                <h3><?php esc_html_e('Automation', 'kds-report-for-orderable'); ?></h3>
                <p><?php esc_html_e('Reduce manual work with automated workflows and processes', 'kds-report-for-orderable'); ?></p>
            </div>

            <div class="kdsamref-advantage-card">
                <div class="kdsamref-advantage-icon"><i class="fas fa-bullseye"></i></div>
                <h3><?php esc_html_e('Customization', 'kds-report-for-orderable'); ?></h3>
                <p><?php esc_html_e('Full control over your order management process', 'kds-report-for-orderable'); ?></p>
            </div>

            <div class="kdsamref-advantage-card">
                <div class="kdsamref-advantage-icon"><i class="fas fa-mobile-alt"></i></div>
                <h3><?php esc_html_e('Mobile Optimization', 'kds-report-for-orderable'); ?></h3>
                <p><?php esc_html_e('Enhanced tablet and mobile experience for your team', 'kds-report-for-orderable'); ?></p>
            </div>

            <div class="kdsamref-advantage-card">
                <div class="kdsamref-advantage-icon"><i class="fas fa-briefcase"></i></div>
                <h3><?php esc_html_e('Business Growth', 'kds-report-for-orderable'); ?></h3>
                <p><?php esc_html_e('Professional tools to scale your restaurant operations', 'kds-report-for-orderable'); ?></p>
            </div>
        </div>
    </div>

    <!-- CTA Section -->
    <div class="kdsamref-cta-section">
        <div class="kdsamref-cta-content">
            <h2><?php esc_html_e('Ready to upgrade?', 'kds-report-for-orderable'); ?></h2>
            <p><?php esc_html_e('Join thousands of restaurants using Pro to streamline their operations', 'kds-report-for-orderable'); ?></p>
            <div class="kdsamref-cta-actions">
                <a href="https://codeon.ch/orderable-kds" target="_blank" rel="noopener" class="kdsamref-cta-primary">
                    <?php esc_html_e('Upgrade to Pro Now', 'kds-report-for-orderable'); ?>
                </a>
                <a href="https://codeon.ch/orderable-kds" target="_blank" rel="noopener" class="kdsamref-cta-secondary">
                    <?php esc_html_e('Learn More', 'kds-report-for-orderable'); ?>
                </a>
            </div>
        </div>
    </div>
</div>
