<?php
/**
 * Plugin Name: KDS & Report for Orderable Pro
 * Plugin URI: https://codeon.ch/orderable-kds
 * Description: Pro add-on for KDS & Report for Orderable. Enables premium features with a valid license.
 * Version: 3.0.2
 * Author: Codeon
 * Author URI: https://codeon.ch
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * Text Domain: kds-report-for-orderable-pro
 * Domain Path: /languages
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Define constants
if (!defined('KDSAMREF_PRO_VERSION')) {
    define('KDSAMREF_PRO_VERSION', '3.0.2');
}
if (!defined('KDSAMREF_PRO_PRODUCT_ID')) {
    // Embedded product id for License Manager V2
    define('KDSAMREF_PRO_PRODUCT_ID', '4862');
}
if (!defined('KDSAMREF_PRO_PLUGIN_FILE')) {
    define('KDSAMREF_PRO_PLUGIN_FILE', __FILE__);
}
if (!defined('KDSAMREF_PRO_PLUGIN_PATH')) {
    define('KDSAMREF_PRO_PLUGIN_PATH', plugin_dir_path(__FILE__));
}
if (!defined('KDSAMREF_PRO_PLUGIN_URL')) {
    define('KDSAMREF_PRO_PLUGIN_URL', plugin_dir_url(__FILE__));
}

// Note: For WordPress.org, translations auto-load; no manual textdomain load needed

// Check Core presence
function kdsamref_pro_check_core_active() {
    if (!function_exists('kdsamref_is_pro_active')) {
        add_action('admin_notices', function () {
            echo '<div class="notice notice-error"><p>' . esc_html__('KDS & Report for Orderable Core plugin is required for the Pro add-on.', 'kds-report-for-orderable-pro') . '</p></div>';
        });
        return false;
    }
    return true;
}

// Include Pro License Manager
require_once KDSAMREF_PRO_PLUGIN_PATH . 'includes/class-kdsamref-pro-license-manager.php';

// Initialize
add_action('plugins_loaded', function () {
    if (!kdsamref_pro_check_core_active()) {
        return;
    }

    // Initialize license manager
    KDSAMREF_Pro_License_Manager::instance();

    // Gate Core features via filters when license is valid
    add_filter('kdsamref/is_pro_active', function ($active) {
        return $active || KDSAMREF_Pro_License_Manager::is_license_valid();
    }, 10, 1);

    add_filter('kdsamref/features', function ($features) {
        if (KDSAMREF_Pro_License_Manager::is_license_valid()) {
            $features['auto_refresh'] = true;
            $features['monthly_reports'] = true;
            $features['pos'] = true;
            $features['workflows'] = true;
        }
        return $features;
    }, 10, 1);

    // Add Pro License submenu under Core menu
    add_action('admin_menu', function () {
        $capability = current_user_can('manage_kdsamref_orders') ? 'manage_kdsamref_orders' : 'manage_woocommerce';
        add_submenu_page(
            'kdsamref-dashboard',
            esc_html__('Pro License', 'kds-report-for-orderable-pro'),
            esc_html__('Pro License', 'kds-report-for-orderable-pro'),
            $capability,
            'kdsamref-pro-license',
            array(KDSAMREF_Pro_License_Manager::instance(), 'render_license_page')
        );
    });
    
    // Enqueue assets for Pro License page only
    add_action('admin_enqueue_scripts', function ($hook) {
        if (strpos($hook, 'kdsamref-pro-license') === false) {
            return;
        }
        wp_enqueue_style(
            'kdsamref-pro-license-style',
            KDSAMREF_PRO_PLUGIN_URL . 'assets/css/pro-license.css',
            array(),
            KDSAMREF_PRO_VERSION
        );
        wp_enqueue_script(
            'kdsamref-pro-license-script',
            KDSAMREF_PRO_PLUGIN_URL . 'assets/js/pro-license.js',
            array('jquery'),
            KDSAMREF_PRO_VERSION,
            true
        );
        wp_localize_script('kdsamref-pro-license-script', 'kdsamrefProLicense', array(
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('kdsamref_pro_license_nonce'),
            'i18n' => array(
                'validating' => __('Validating...', 'kds-report-for-orderable-pro'),
                'validated' => __('License validated successfully', 'kds-report-for-orderable-pro'),
                'deactivated' => __('License deactivated', 'kds-report-for-orderable-pro'),
                'error' => __('Error', 'kds-report-for-orderable-pro'),
                'ok' => __('OK', 'kds-report-for-orderable-pro'),
            )
        ));
    });
    // Handle telemetry preference save
    add_action('admin_post_kdsamref_pro_save_telemetry', array(KDSAMREF_Pro_License_Manager::instance(), 'handle_save_telemetry'));

    // Product id is embedded via KDSAMREF_PRO_PRODUCT_ID; no user input required
});

// Activation: nothing special for now
register_activation_hook(__FILE__, function () {
    // Placeholder for future DB or schedule needs
});

// Deactivation: cleanup schedules if any
register_deactivation_hook(__FILE__, function () {
    wp_clear_scheduled_hook('kdsamref_pro_hourly_license_check');
});