<?php
/**
 * Monthly Reports Template
 * 
 * Template for displaying monthly reports
 */

if (!defined('ABSPATH')) {
    exit;
}

?>
<!-- CSS loaded via WordPress enqueue system -->

<div class="wrap kdsamref-monthly-reports">
    <div class="kdsamref-header">
        <h1><?php esc_html_e('Monthly Reports', 'kds-report-for-orderable'); ?></h1>
        <p class="kdsamref-subtitle"><?php esc_html_e('Monthly order and tip analysis', 'kds-report-for-orderable'); ?></p>
    </div>
    
    <div class="kdsamref-month-selector">
        <form method="get">
            <input type="hidden" name="page" value="kdsamref-monthly-reports">
            
            <div class="kdsamref-filter-row">
                <div class="kdsamref-filter-item">
                    <label for="month"><?php esc_html_e('Month:', 'kds-report-for-orderable'); ?></label>
<input type="month" name="month" id="month" value="<?php echo esc_attr(isset($current_month) ? $current_month : gmdate('Y-m')); ?>">
                </div>
                
                <div class="kdsamref-filter-item">
                    <label for="category"><?php esc_html_e('Category:', 'kds-report-for-orderable'); ?></label>
                    <select name="category" id="category">
                        <option value="0"><?php esc_html_e('All categories', 'kds-report-for-orderable'); ?></option>
                        <?php if (isset($categories) && !empty($categories)): ?>
                            <?php foreach ($categories as $category): ?>
                                <option value="<?php echo esc_attr($category->term_id); ?>" <?php selected(isset($selected_category) ? $selected_category : 0, $category->term_id); ?>>
                                    <?php echo esc_html($category->name); ?>
                                </option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </div>
                
                <div class="kdsamref-filter-item">
                    <button type="submit" class="button button-primary"><?php esc_html_e('View Report', 'kds-report-for-orderable'); ?></button>
                </div>
            </div>
        </form>
    </div>
    
    <div class="kdsamref-reports-grid">
        <div class="kdsamref-card">
            <h3><?php esc_html_e('Monthly Orders', 'kds-report-for-orderable'); ?>
                <?php if (isset($selected_category) && $selected_category > 0): ?>
                    <?php 
                    $category = get_term($selected_category, 'product_cat');
                    if ($category && !is_wp_error($category)) {
                        echo '<br><small>(' . esc_html($category->name);
                        
                        // Show number of subcategories
                        $children = get_term_children($selected_category, 'product_cat');
                        if (!is_wp_error($children) && !empty($children)) {
                            echo ' + ' . count($children) . ' ' . esc_html__('sub-categories', 'kds-report-for-orderable');
                        }
                        echo ')</small>';
                    }
                    ?>
                <?php endif; ?>
            </h3>
            <div class="kdsamref-metric">
                <span class="kdsamref-number"><?php echo esc_html(isset($reports_data['total_orders']) ? $reports_data['total_orders'] : 0); ?></span>
                <span class="kdsamref-label"><?php esc_html_e('orders', 'kds-report-for-orderable'); ?></span>
            </div>
        </div>
        
        <div class="kdsamref-card">
            <h3><?php esc_html_e('Gross Amount', 'kds-report-for-orderable'); ?></h3>
            <div class="kdsamref-metric">
                <span class="kdsamref-number"><?php echo wp_kses_post(wc_price(isset($reports_data['gross_total']) ? $reports_data['gross_total'] : 0)); ?></span>
                <span class="kdsamref-label"><?php esc_html_e('with taxes', 'kds-report-for-orderable'); ?></span>
            </div>
        </div>
        
        <div class="kdsamref-card">
            <h3><?php esc_html_e('Net Amount', 'kds-report-for-orderable'); ?></h3>
            <div class="kdsamref-metric">
                <span class="kdsamref-number"><?php echo wp_kses_post(wc_price(isset($reports_data['net_total']) ? $reports_data['net_total'] : 0)); ?></span>
                <span class="kdsamref-label"><?php esc_html_e('excluding taxes', 'kds-report-for-orderable'); ?></span>
            </div>
        </div>
        
        <div class="kdsamref-card">
            <h3><?php esc_html_e('Tips', 'kds-report-for-orderable'); ?></h3>
            <div class="kdsamref-metric">
                <span class="kdsamref-number"><?php echo wp_kses_post(wc_price(isset($reports_data['tips_total']) ? $reports_data['tips_total'] : 0)); ?></span>
                <span class="kdsamref-label"><?php echo esc_html(isset($reports_data['tips_count']) ? $reports_data['tips_count'] : 0); ?> <?php esc_html_e('orders with tips', 'kds-report-for-orderable'); ?></span>
            </div>
        </div>
    </div>
    
    <?php if (isset($reports_data['daily_breakdown']) && !empty($reports_data['daily_breakdown'])): ?>
    <div class="kdsamref-detailed-table">
        <h3><?php esc_html_e('Daily Breakdown', 'kds-report-for-orderable'); ?></h3>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php esc_html_e('Date', 'kds-report-for-orderable'); ?></th>
                    <th><?php esc_html_e('Orders', 'kds-report-for-orderable'); ?></th>
                    <th><?php esc_html_e('Gross Amount', 'kds-report-for-orderable'); ?></th>
                    <th><?php esc_html_e('Net Amount', 'kds-report-for-orderable'); ?></th>
                    <th><?php esc_html_e('Tips', 'kds-report-for-orderable'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($reports_data['daily_breakdown'] as $day => $data): ?>
                <tr>
                    <td><?php echo esc_html(date_i18n('d/m/Y', strtotime($day))); ?></td>
                    <td><?php echo esc_html($data['orders']); ?></td>
                    <td><?php echo wp_kses_post(wc_price($data['gross'])); ?></td>
                    <td><?php echo wp_kses_post(wc_price($data['net'])); ?></td>
                    <td><?php echo wp_kses_post(wc_price($data['tips'])); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
    
    <?php if (isset($comparison_data) && !empty($comparison_data)): ?>
    <div class="kdsamref-detailed-table">
        <h3><?php esc_html_e('Monthly Comparison (Last 6 Months)', 'kds-report-for-orderable'); ?></h3>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php esc_html_e('Month', 'kds-report-for-orderable'); ?></th>
                    <th><?php esc_html_e('Orders', 'kds-report-for-orderable'); ?></th>
                    <th><?php esc_html_e('Gross Amount', 'kds-report-for-orderable'); ?></th>
                    <th><?php esc_html_e('Net Amount', 'kds-report-for-orderable'); ?></th>
                    <th><?php esc_html_e('Tips', 'kds-report-for-orderable'); ?></th>
                    <th><?php esc_html_e('Evolution', 'kds-report-for-orderable'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($comparison_data as $index => $month_data): 
                    $evolution_class = '';
                    $evolution_icon = '';
                    
                    // Compare with previous month (index 0 is first month)
                    if ($index > 0) {
                        $previous_month = $comparison_data[$index - 1];
                        if ($previous_month['gross_total'] > 0) {
                            $evolution_percent = (($month_data['gross_total'] - $previous_month['gross_total']) / $previous_month['gross_total']) * 100;
                            if ($evolution_percent > 0) {
                                $evolution_class = 'kdsamref-evolution-up';
                                $evolution_icon = '↗ +' . number_format($evolution_percent, 1) . '%';
                            } elseif ($evolution_percent < 0) {
                                $evolution_class = 'kdsamref-evolution-down';
                                $evolution_icon = '↘ ' . number_format($evolution_percent, 1) . '%';
                            } else {
                                $evolution_icon = '→ 0%';
                            }
                        }
                    }
                ?>
                <tr <?php echo esc_attr($month_data['is_current'] ? 'class="kdsamref-current-month"' : ''); ?>>
                    <td>
                        <strong><?php echo esc_html(date_i18n('F Y', strtotime($month_data['month'] . '-01'))); ?></strong>
                        <?php if ($month_data['is_current']): ?>
                            <span class="kdsamref-current-badge"><?php esc_html_e('Current', 'kds-report-for-orderable'); ?></span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo esc_html($month_data['total_orders']); ?></td>
                    <td><?php echo wp_kses_post(wc_price($month_data['gross_total'])); ?></td>
                    <td><?php echo wp_kses_post(wc_price($month_data['net_total'])); ?></td>
                    <td><?php echo wp_kses_post(wc_price($month_data['tips_total'])); ?></td>
                    <td><span class="<?php echo esc_attr($evolution_class); ?>"><?php echo esc_html($evolution_icon); ?></span></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
    
    <div class="kdsamref-footer">
        <div class="kdsamref-footer-content">
            <div class="kdsamref-footer-left">
                <p><?php esc_html_e('Developed by', 'kds-report-for-orderable'); ?> <a href="https://codeon.ch" target="_blank">Codeon.ch</a></p>
                <p class="kdsamref-footer-tagline"><?php esc_html_e('Digital solutions for all businesses', 'kds-report-for-orderable'); ?></p>
            </div>
            <div class="kdsamref-footer-right">
                <a href="https://codeon.ch/contact/" target="_blank" class="kdsamref-footer-link">
                    <?php esc_html_e('Technical Support', 'kds-report-for-orderable'); ?>
                </a>
                <span class="kdsamref-swiss-label">🇨🇭 Swiss Quality</span>
            </div>
        </div>
    </div>
</div> 