<?php
/**
 * Admin Settings Template - Optimized for Production
 * CSS/JS moved to separate files, console logs removed
 */

if (!defined('ABSPATH')) {
    exit;
}

// Check permissions
if (!current_user_can('manage_kdsamref_orders') && !current_user_can('manage_options')) {
    wp_die(esc_html__('Permission denied', 'kds-report-for-orderable'));
}

// Fallback for sanitize_hex_color if not available (older WP versions)
if (!function_exists('sanitize_hex_color')) {
    function sanitize_hex_color($color) {
        if ('' === $color) {
            return '';
        }
        
        // 3 or 6 hex digits, or the empty string.
        if (preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color)) {
            return $color;
        }
        
        return null;
    }
}

// Initialize required objects early
$admin = new KDSAMREF_Admin();
$is_pro_active = function_exists('kdsamref_is_pro_active') ? kdsamref_is_pro_active() : false;
// License UI is handled by Pro add-on page, not here



// Handle form submission
        if (isset($_POST['submit']) && isset($_POST['_wpnonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'kdsamref_settings')) {
    // Check permissions
    if (!current_user_can('manage_kdsamref_orders') && !current_user_can('manage_options')) {
        echo '<div class="notice notice-error"><p><strong>' . esc_html__('Insufficient permission to save settings.', 'kds-report-for-orderable') . '</strong></p></div>';
    } else {
        try {
            // Process settings save
            
            // Process settings save
            
            $total_operations = 0;
            
            // Save compatibility mode separately
            if (isset($_POST['kdsamref_settings']['compatibility_mode'])) {
                $compatibility_mode = sanitize_text_field(wp_unslash($_POST['kdsamref_settings']['compatibility_mode']));
                if (in_array($compatibility_mode, ['auto', 'orderable', 'woocommerce'])) {
                    $compat_result = update_option('kdsamref_compatibility_mode', $compatibility_mode);
                    $total_operations++;
                }
            }
            
            // Validate and sanitize all settings
            $settings = array();
            
            // Dashboard Settings with validation and defaults
            if (isset($_POST['kdsamref_settings']['max_orders_limit'])) {
                $settings['max_orders_limit'] = max(10, min(500, intval(sanitize_text_field(wp_unslash($_POST['kdsamref_settings']['max_orders_limit'])))));
            }
            
            // dashboard_language ile ilgili gereksiz kodlar kaldırıldı
            
            if (isset($_POST['kdsamref_settings']['default_font_size'])) {
                $settings['default_font_size'] = max(80, min(140, intval(sanitize_text_field(wp_unslash($_POST['kdsamref_settings']['default_font_size'])))));
            }
            
            if (isset($_POST['kdsamref_settings']['auto_refresh_interval'])) {
                $interval = intval(sanitize_text_field(wp_unslash($_POST['kdsamref_settings']['auto_refresh_interval'])));
                $settings['auto_refresh_interval'] = ($is_pro_active ? max(5, min(300, $interval)) : 0);
            }
            
            // Boolean settings
            $boolean_settings = [
                'enable_notifications', 'notification_sound', 'disable_refresh_notifications', 'show_completed_orders',
                'compact_mode', 'show_order_numbers', 'show_customer_names',
                'show_product_options', 'show_tips', 'show_fees'
            ];
            
            foreach ($boolean_settings as $setting) {
                $settings[$setting] = isset($_POST['kdsamref_settings'][$setting]) ? 1 : 0;
            }
            
            // Float settings
            if (isset($_POST['kdsamref_settings']['notification_volume'])) {
                $settings['notification_volume'] = max(0.1, min(1.0, floatval(wp_unslash($_POST['kdsamref_settings']['notification_volume']))));
            }
            

            
            if (isset($_POST['kdsamref_settings']['completed_orders_opacity'])) {
                $settings['completed_orders_opacity'] = max(0.3, min(1.0, floatval(wp_unslash($_POST['kdsamref_settings']['completed_orders_opacity']))));
            }
            
            // Color settings
            $color_settings = ['delivery_badge_color', 'pickup_badge_color', 'dine_in_badge_color'];
            $default_colors = ['#4ade80', '#a78bfa', '#60a5fa'];
            
            foreach ($color_settings as $i => $setting) {
                if (isset($_POST['kdsamref_settings'][$setting])) {
                    $raw_color = sanitize_text_field(wp_unslash($_POST['kdsamref_settings'][$setting]));
                    $color = sanitize_hex_color($raw_color);
                    $settings[$setting] = $color ? $color : $default_colors[$i];
                }
            }
            
            // Custom Statuses
            if (isset($_POST['kdsamref_settings']['custom_statuses']) && is_array($_POST['kdsamref_settings']['custom_statuses'])) {
                $custom_statuses = array();
                foreach ($_POST['kdsamref_settings']['custom_statuses'] as $slug => $status_data) {
                    if (!empty($slug) && !empty($status_data['label'])) {
                        $custom_statuses[sanitize_key($slug)] = array(
                            'label' => sanitize_text_field(wp_unslash($status_data['label'])),
                            'color' => sanitize_hex_color(wp_unslash($status_data['color'])) ?: '#007cba',
                            'source' => isset($status_data['source']) ? sanitize_text_field(wp_unslash($status_data['source'])) : 'custom'
                        );
                    }
                }
                $settings['custom_statuses'] = $custom_statuses;
                
                // Re-register custom statuses with WooCommerce after saving
                if (class_exists('KDSAMREF_Admin')) {
                    $admin = new KDSAMREF_Admin();
                    $admin->register_custom_statuses_with_wc();
                }
            }
            

            
            // Status Order, Colors, and Labels
            if (isset($_POST['kdsamref_settings']['status_order']) && is_array($_POST['kdsamref_settings']['status_order'])) {
                $settings['status_order'] = array_map('sanitize_text_field', array_map('wp_unslash', $_POST['kdsamref_settings']['status_order']));
            }
            
            if (isset($_POST['kdsamref_settings']['status_colors']) && is_array($_POST['kdsamref_settings']['status_colors'])) {
                $status_colors = array();
                foreach ($_POST['kdsamref_settings']['status_colors'] as $status => $color) {
                    $sanitized_color = sanitize_hex_color(wp_unslash($color));
                    if ($sanitized_color) {
                        $status_colors[sanitize_text_field(wp_unslash($status))] = $sanitized_color;
                    }
                }
                $settings['status_colors'] = $status_colors;
            }
            
            if (isset($_POST['kdsamref_settings']['status_labels']) && is_array($_POST['kdsamref_settings']['status_labels'])) {
                $status_labels = array();
                foreach ($_POST['kdsamref_settings']['status_labels'] as $status => $label) {
                    if (!empty($label)) {
                        $status_labels[sanitize_text_field(wp_unslash($status))] = sanitize_text_field(wp_unslash($label));
                    }
                }
                $settings['status_labels'] = $status_labels;
            }
            
            // UI Colors
            $ui_color_settings = ['border_color_primary', 'border_color_secondary', 'card_background_color', 'dashboard_background_color'];
            foreach ($ui_color_settings as $setting) {
                if (isset($_POST['kdsamref_settings'][$setting])) {
                    $color = sanitize_hex_color(wp_unslash($_POST['kdsamref_settings'][$setting]));
                    if ($color) {
                        $settings[$setting] = $color;
                    }
                }
            }
            
            // Remove any empty values (but preserve color settings even if they're empty strings)
            $settings = array_filter($settings, function($value, $key) {
                // Don't filter out color settings even if they're empty
                if (in_array($key, ['delivery_badge_color', 'pickup_badge_color', 'dine_in_badge_color'])) {
                    return true;
                }
                return $value !== '' && $value !== null;
            }, ARRAY_FILTER_USE_BOTH);
            
            // Save main settings
            if (!empty($settings)) {
                $current_settings = get_option('kdsamref_settings', array());
                $merged_settings = array_merge($current_settings, $settings);
                $result = update_option('kdsamref_settings', $merged_settings);
                $total_operations++;
            }
            
            // Show result based on success rate
            if ($total_operations > 0) {
                // WordPress update_option returns false when value is unchanged, not on actual failure
                // So we consider it successful if we have operations to perform
                echo '<div class="notice notice-success"><p><strong>' . esc_html__('Settings saved successfully!', 'kds-report-for-orderable') . '</strong></p></div>';
                

            } else {
                echo '<div class="notice notice-info"><p><strong>' . esc_html__('No settings to save.', 'kds-report-for-orderable') . '</strong></p></div>';
            }
            
        } catch (Exception $e) {
            echo '<div class="notice notice-error"><p><strong>' . esc_html__('Error saving settings:', 'kds-report-for-orderable') . ' ' . esc_html($e->getMessage()) . '</strong></p></div>';
        }
    }
}

$settings = $admin->get_all_settings();



// CSS/JS are now enqueued in the main plugin file
?>

<div class="wrap kdsamref-settings-modern">
    <!-- Modern Header -->
    <div class="kdsamref-settings-header">
        <div class="kdsamref-header-content">
            <div class="kdsamref-header-left">
                <h1 class="kdsamref-settings-title"><?php esc_html_e('KDS & Report for Orderable - Settings', 'kds-report-for-orderable'); ?></h1>
                <p class="kdsamref-settings-subtitle"><?php esc_html_e('Order management system configuration', 'kds-report-for-orderable'); ?></p>
            </div>
        </div>
    </div>
    
    <!-- Settings Tabs Navigation -->
    <div class="kdsamref-settings-tabs">
        <button type="button" class="kdsamref-tab-btn active" data-tab="general"><?php esc_html_e('General Settings', 'kds-report-for-orderable'); ?></button>

        <?php /* Pro lisans yönetimi Pro eklentide ayrı sayfada: kdsamref-pro-license */ ?>
    </div>

    <!-- Tab Content: General Settings -->
    <div class="kdsamref-tab-content" id="tab-general">
        <form method="post" action="" class="kdsamref-settings-form">
            <?php wp_nonce_field('kdsamref_settings', '_wpnonce'); ?>
            
            <!-- Dashboard Settings -->
            <div class="kdsamref-settings-section">
                <div class="kdsamref-section-header">
                    <h2><?php esc_html_e('Dashboard', 'kds-report-for-orderable'); ?></h2>
                    <span class="kdsamref-section-description"><?php esc_html_e('Main interface configuration', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-section-content">
                    <div class="kdsamref-settings-grid">
                        <div class="kdsamref-setting-group">
                            <label for="max_orders_limit"><?php esc_html_e('Order limit', 'kds-report-for-orderable'); ?></label>
                            <input type="number" id="max_orders_limit" name="kdsamref_settings[max_orders_limit]" 
                                   value="<?php echo esc_attr($settings['max_orders_limit'] ?? 100); ?>" 
                                   min="10" max="500" step="10" />
                            <span class="kdsamref-setting-hint"><?php esc_html_e('Maximum number of orders to display (10-500)', 'kds-report-for-orderable'); ?></span>
                        </div>
                        

                        
                        <div class="kdsamref-setting-group">
                            <label for="auto_refresh_interval"><?php esc_html_e('Auto refresh', 'kds-report-for-orderable'); ?></label>
                            <?php if ($is_pro_active): ?>
                                <input type="number" id="auto_refresh_interval" name="kdsamref_settings[auto_refresh_interval]" 
                                       value="<?php echo esc_attr($settings['auto_refresh_interval'] ?? 15); ?>" 
                                       min="5" max="300" />
                                <span class="kdsamref-setting-hint"><?php esc_html_e('seconds (5-300)', 'kds-report-for-orderable'); ?></span>
                            <?php else: ?>
                                <input type="number" id="auto_refresh_interval" name="kdsamref_settings[auto_refresh_interval]" 
                                       value="0" disabled class="kdsamref-setting-disabled" />
                                <span class="kdsamref-setting-hint"></span>
                                    <i class="fas fa-lock"></i> <?php esc_html_e('Premium Feature - Manual refresh only in free version', 'kds-report-for-orderable'); ?>
                                    <a href="https://codeon.ch/orderable-kds" target="_blank" rel="noopener" class="kdsamref-setting-link">
                                        <?php esc_html_e('Upgrade to Pro', 'kds-report-for-orderable'); ?>
                                    </a>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Pro Status (always visible in General) -->
            <div class="kdsamref-settings-section">
                <div class="kdsamref-section-header">
                    <h2><?php esc_html_e('Pro Status', 'kds-report-for-orderable'); ?></h2>
                    <span class="kdsamref-section-description"><?php esc_html_e('Your plan and feature availability', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-section-content">
                    <?php 
                        $status_text = $is_pro_active ? esc_html__('Premium active', 'kds-report-for-orderable') : esc_html__('Free version', 'kds-report-for-orderable');
                        $status_desc = $is_pro_active 
                                            ? esc_html__('Auto-refresh, Workflows and Monthly Reports are enabled.', 'kds-report-for-orderable')
                : esc_html__('Pro features (Auto-refresh, Workflows, Monthly Reports) are locked.', 'kds-report-for-orderable');
                    ?>
                    <div class="kdsamref-license-status"></div>
                        <span class="kdsamref-license-status-indicator">
                            <span class="kdsamref-license-status-dot" style="--license-status-color: <?php echo esc_attr($is_pro_active ? '#10b981' : '#9ca3af'); ?>;"></span>
                            <?php echo esc_html($status_text); ?>
                        </span>
                        <span class="kdsamref-license-status-text">
                            <?php echo esc_html($status_desc); ?>
                        </span>
                        <?php if (!$is_pro_active): ?>
                            <a href="https://codeon.ch/orderable-kds" target="_blank" rel="noopener" class="kdsamref-license-upgrade-link">
                                <?php esc_html_e('Upgrade to Pro', 'kds-report-for-orderable'); ?> →
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Compatibility Mode (moved under General) -->
            <div class="kdsamref-settings-section">
                <div class="kdsamref-section-header">
                    <h2><?php esc_html_e('Compatibility Mode', 'kds-report-for-orderable'); ?></h2>
                    <span class="kdsamref-section-description"><?php esc_html_e('Select how the plugin operates with or without Orderable', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-section-content">
                    <?php 
                            require_once KDSAMREF_PLUGIN_PATH . 'includes/class-kdsamref-compatibility-manager.php';
        $current_mode = KDSAMREF_Compatibility_Manager::get_mode();
        $orderable_active = KDSAMREF_Compatibility_Manager::is_orderable_active();
        $mode_settings = KDSAMREF_Compatibility_Manager::get_mode_settings();
                    ?>
                    <div class="kdsamref-compatibility-status">
                        <div class="kdsamref-mode-current">
                            <strong><?php esc_html_e('Current mode:', 'kds-report-for-orderable'); ?></strong>
                            <span class="kdsamref-mode-badge kdsamref-mode-<?php echo esc_attr($current_mode); ?>">
                                <?php echo esc_html($mode_settings['display_name']); ?>
                            </span>
                        </div>
                        <div class="kdsamref-orderable-detection">
                            <strong><?php esc_html_e('Orderable detected:', 'kds-report-for-orderable'); ?></strong>
                            <span class="kdsamref-detection-badge <?php echo esc_attr($orderable_active ? 'detected' : 'not-detected'); ?>">
                                <?php echo esc_html($orderable_active ? '✅ Oui' : '❌ Non'); ?>
                            </span>
                        </div>
                    </div>
                    <div class="kdsamref-setting-group">
                        <label for="kdsamref_compatibility_mode"><?php esc_html_e('Compatibility mode', 'kds-report-for-orderable'); ?></label>
                        <select id="kdsamref_compatibility_mode" name="kdsamref_settings[compatibility_mode]">
                            <option value="auto" <?php selected('auto', get_option('kdsamref_compatibility_mode', 'auto')); ?>>
                                <?php esc_html_e('Automatic detection', 'kds-report-for-orderable'); ?>
                            </option>
                            <option value="orderable" <?php selected('orderable', get_option('kdsamref_compatibility_mode', 'auto')); ?>>
                                <?php esc_html_e('Orderable Mode (complete)', 'kds-report-for-orderable'); ?>
                            </option>
                            <option value="woocommerce" <?php selected('woocommerce', get_option('kdsamref_compatibility_mode', 'auto')); ?>>
                                <?php esc_html_e('WooCommerce Mode (standard)', 'kds-report-for-orderable'); ?>
                            </option>
                        </select>
                        <div class="kdsamref-setting-description">
                            <div class="kdsamref-mode-descriptions">
                                <div class="kdsamref-mode-desc" data-mode="auto">
                                    <strong><?php esc_html_e('Automatic detection:', 'kds-report-for-orderable'); ?></strong>
                                    <?php esc_html_e('The plugin automatically detects Orderable and activates the appropriate mode.', 'kds-report-for-orderable'); ?>
                                </div>
                                <div class="kdsamref-mode-desc" data-mode="orderable">
                                    <strong><?php esc_html_e('Orderable Mode:', 'kds-report-for-orderable'); ?></strong>
                                    <?php esc_html_e('Uses all Orderable features: service types, scheduling, table numbers, etc.', 'kds-report-for-orderable'); ?>
                                </div>
                                <div class="kdsamref-mode-desc" data-mode="woocommerce">
                                    <strong><?php esc_html_e('WooCommerce Mode:', 'kds-report-for-orderable'); ?></strong>
                                    <?php esc_html_e('Compatible with standard WooCommerce. Delivery types based on shipping methods.', 'kds-report-for-orderable'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if (!$orderable_active): ?>
                    <div class="kdsamref-compatibility-warning">
                        <div class="kdsamref-warning-content">
                            <span class="kdsamref-warning-icon">⚠️</span>
                            <div class="kdsamref-warning-text">
                                <strong><?php esc_html_e('Orderable not detected', 'kds-report-for-orderable'); ?></strong>
                                <p><?php esc_html_e('The Orderable plugin is not installed or activated. WooCommerce mode will be used automatically.', 'kds-report-for-orderable'); ?></p>
                                <div class="kdsamref-warning-actions">
                                    <a href="https://wordpress.org/plugins/orderable/" target="_blank" class="button button-secondary">
                                        <?php esc_html_e('Install Orderable', 'kds-report-for-orderable'); ?>
                                    </a>
                                    <span class="kdsamref-warning-note"><?php esc_html_e('or continue with the standard WooCommerce mode', 'kds-report-for-orderable'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="kdsamref-compatibility-info">
                        <h4><?php esc_html_e('Allowed order statuses (current mode):', 'kds-report-for-orderable'); ?></h4>
                        <div class="kdsamref-status-list">
                            <?php foreach ($mode_settings['valid_statuses'] as $status): ?>
                                <span class="kdsamref-status-item"><?php echo esc_html($status); ?></span>
                            <?php endforeach; ?>
                        </div>
                        <h4><?php esc_html_e('Filtered (ignored) statuses:', 'kds-report-for-orderable'); ?></h4>
                        <div class="kdsamref-forbidden-list">
                            <?php foreach ($mode_settings['forbidden_statuses'] as $status): ?>
                                <span class="kdsamref-forbidden-item"><?php echo esc_html($status); ?></span>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Notifications Settings -->
            <div class="kdsamref-settings-section">
                <div class="kdsamref-section-header">
                    <h2><?php esc_html_e('Notifications', 'kds-report-for-orderable'); ?></h2>
                    <span class="kdsamref-section-description"><?php esc_html_e('Alert and sound configuration', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-section-content">
                    <div class="kdsamref-settings-grid">
                        <div class="kdsamref-setting-group">
                            <div class="kdsamref-checkbox-group">
                                <input type="checkbox" id="enable_notifications" name="kdsamref_settings[enable_notifications]" 
                                       value="1" <?php checked(1, $settings['enable_notifications'] ?? 1); ?> />
                                <label for="enable_notifications"><?php esc_html_e('Enable browser notifications', 'kds-report-for-orderable'); ?></label>
                            </div>
                        </div>
                        
                        <div class="kdsamref-setting-group">
                            <div class="kdsamref-checkbox-group">
                                <input type="checkbox" id="notification_sound" name="kdsamref_settings[notification_sound]" 
                                       value="1" <?php checked(1, $settings['notification_sound'] ?? 1); ?> />
                                <label for="notification_sound"><?php esc_html_e('Notification sound', 'kds-report-for-orderable'); ?></label>
                            </div>
                        </div>
                        
                        <div class="kdsamref-setting-group">
                            <div class="kdsamref-checkbox-group">
                                <input type="checkbox" id="disable_refresh_notifications" name="kdsamref_settings[disable_refresh_notifications]" 
                                       value="1" <?php checked(1, $settings['disable_refresh_notifications'] ?? 0); ?> />
                                <label for="disable_refresh_notifications"><?php esc_html_e('Disable refresh notifications', 'kds-report-for-orderable'); ?></label>
                                <span class="kdsamref-setting-hint"><?php esc_html_e('Hide "Refresh completed" notifications', 'kds-report-for-orderable'); ?></span>
                            </div>
                        </div>
                        
                        <div class="kdsamref-setting-group">
                            <label for="notification_volume"><?php esc_html_e('Volume', 'kds-report-for-orderable'); ?></label>
                            <div class="kdsamref-range-container">
                                <input type="range" id="notification_volume" name="kdsamref_settings[notification_volume]" 
                                       value="<?php echo esc_attr($settings['notification_volume'] ?? 0.3); ?>" 
                                       min="0.1" max="1.0" step="0.1" />
                                <span id="volume_display"><?php echo esc_html(($settings['notification_volume'] ?? 0.3) * 100); ?>%</span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Display Settings -->
            <div class="kdsamref-settings-section">
                <div class="kdsamref-section-header">
                    <h2><?php esc_html_e('Display', 'kds-report-for-orderable'); ?></h2>
                    <span class="kdsamref-section-description"><?php esc_html_e('Display and layout options', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-section-content">
                    <div class="kdsamref-settings-grid">
                        <div class="kdsamref-setting-group">
                            <label for="default_font_size"><?php esc_html_e('Font size', 'kds-report-for-orderable'); ?></label>
                            <div class="kdsamref-range-container">
                                <input type="range" id="default_font_size" name="kdsamref_settings[default_font_size]" 
                                       value="<?php echo esc_attr($settings['default_font_size'] ?? 100); ?>" 
                                       min="80" max="140" step="5" />
                                <span id="font_size_display"><?php echo esc_html($settings['default_font_size'] ?? 100); ?>%</span>
                            </div>
                        </div>
                        
                        <div class="kdsamref-setting-group">
                            <div class="kdsamref-checkbox-group">
                                <input type="checkbox" id="compact_mode" name="kdsamref_settings[compact_mode]" 
                                       value="1" <?php checked(1, $settings['compact_mode'] ?? 0); ?> />
                                <label for="compact_mode"><?php esc_html_e('Compact mode', 'kds-report-for-orderable'); ?></label>
                                <span class="kdsamref-setting-hint"><?php esc_html_e('Show more orders in a compact layout', 'kds-report-for-orderable'); ?></span>
                            </div>
                        </div>
                        
                        <div class="kdsamref-setting-group">
                            <div class="kdsamref-checkbox-group">
                                <input type="checkbox" id="show_completed_orders" name="kdsamref_settings[show_completed_orders]" 
                                       value="1" <?php checked(1, $settings['show_completed_orders'] ?? 1); ?> />
                                <label for="show_completed_orders"><?php esc_html_e('Show completed orders', 'kds-report-for-orderable'); ?></label>
                            </div>
                        </div>
                        
                        <div class="kdsamref-setting-group">
                            <label for="completed_orders_opacity"><?php esc_html_e('Completed orders opacity', 'kds-report-for-orderable'); ?></label>
                            <div class="kdsamref-range-container">
                                <input type="range" id="completed_orders_opacity" name="kdsamref_settings[completed_orders_opacity]" 
                                       value="<?php echo esc_attr($settings['completed_orders_opacity'] ?? 0.8); ?>" 
                                       min="0.3" max="1.0" step="0.1" />
                                <span id="opacity_display"><?php echo esc_html(($settings['completed_orders_opacity'] ?? 0.8) * 100); ?>%</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Order Information -->
            <div class="kdsamref-settings-section">
                <div class="kdsamref-section-header">
                    <h2><?php esc_html_e('Order Information', 'kds-report-for-orderable'); ?></h2>
                    <span class="kdsamref-section-description"><?php esc_html_e('Elements to display on order cards', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-section-content">
                    <div class="kdsamref-settings-grid">
                        <div class="kdsamref-setting-group">
                            <div class="kdsamref-checkbox-group">
                                <input type="checkbox" id="show_order_numbers" name="kdsamref_settings[show_order_numbers]" 
                                       value="1" <?php checked(1, $settings['show_order_numbers'] ?? 1); ?> />
                                <label for="show_order_numbers"><?php esc_html_e('Order numbers', 'kds-report-for-orderable'); ?></label>
                            </div>
                        </div>
                        
                        <div class="kdsamref-setting-group">
                            <div class="kdsamref-checkbox-group">
                                <input type="checkbox" id="show_customer_names" name="kdsamref_settings[show_customer_names]" 
                                       value="1" <?php checked(1, $settings['show_customer_names'] ?? 1); ?> />
                                <label for="show_customer_names"><?php esc_html_e('Customer names', 'kds-report-for-orderable'); ?></label>
                            </div>
                        </div>
                        
                        <div class="kdsamref-setting-group">
                            <div class="kdsamref-checkbox-group">
                                <input type="checkbox" id="show_product_options" name="kdsamref_settings[show_product_options]" 
                                       value="1" <?php checked(1, $settings['show_product_options'] ?? 1); ?> />
                                <label for="show_product_options"><?php esc_html_e('Product options', 'kds-report-for-orderable'); ?></label>
                            </div>
                        </div>
                        
                        <div class="kdsamref-setting-group">
                            <div class="kdsamref-checkbox-group">
                                <input type="checkbox" id="show_tips" name="kdsamref_settings[show_tips]" 
                                       value="1" <?php checked(1, $settings['show_tips'] ?? 1); ?> />
                                <label for="show_tips"><?php esc_html_e('Tips', 'kds-report-for-orderable'); ?></label>
                            </div>
                        </div>
                        
                        <div class="kdsamref-setting-group">
                            <div class="kdsamref-checkbox-group">
                                <input type="checkbox" id="show_fees" name="kdsamref_settings[show_fees]" 
                                       value="1" <?php checked(1, $settings['show_fees'] ?? 1); ?> />
                                <label for="show_fees"><?php esc_html_e('Fees', 'kds-report-for-orderable'); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Color Settings -->
            <div class="kdsamref-settings-section">
                <div class="kdsamref-section-header">
                    <h2><?php esc_html_e('Colors', 'kds-report-for-orderable'); ?></h2>
                    <span class="kdsamref-section-description"><?php esc_html_e('Badge colors customization', 'kds-report-for-orderable'); ?></span>
                </div>
                <div class="kdsamref-section-content">
                    <div class="kdsamref-settings-grid">
                        <div class="kdsamref-setting-group">
                                            <label for="delivery_badge_color"><?php esc_html_e('Delivery', 'kds-report-for-orderable'); ?></label>
                <input type="color" id="delivery_badge_color" name="kdsamref_settings[delivery_badge_color]"
                    value="<?php echo esc_attr($settings['delivery_badge_color'] ?? '#4ade80'); ?>" />
                        </div>
                        
                        <div class="kdsamref-setting-group">
                                            <label for="pickup_badge_color"><?php esc_html_e('Takeaway', 'kds-report-for-orderable'); ?></label>
                <input type="color" id="pickup_badge_color" name="kdsamref_settings[pickup_badge_color]"
                    value="<?php echo esc_attr($settings['pickup_badge_color'] ?? '#a78bfa'); ?>" />
                        </div>
                        
                        <div class="kdsamref-setting-group">
                                            <label for="dine_in_badge_color"><?php esc_html_e('Dine in', 'kds-report-for-orderable'); ?></label>
                <input type="color" id="dine_in_badge_color" name="kdsamref_settings[dine_in_badge_color]"
                    value="<?php echo esc_attr($settings['dine_in_badge_color'] ?? '#60a5fa'); ?>" />
                        </div>
                    </div>
                </div>
            </div>
            

            
            <!-- Submit Button -->
            <div class="kdsamref-settings-actions">
                <button type="submit" name="submit" class="button button-primary">
                     <?php esc_html_e('Save Settings', 'kds-report-for-orderable'); ?>
                </button>
                <button type="button" id="kdsamref-reset-settings" class="button button-secondary" 
                                                  onclick="return confirm('Reset all settings to default values?')">
                    <?php esc_html_e('Reset', 'kds-report-for-orderable'); ?>
                </button>
            </div>
        </form>
    </div>



    <?php /* License tab removed; Pro license UI lives under Pro submenu page */ ?>
</div>

<!-- Inline JS removed; handled by assets/js/admin-settings.js -->
<!-- Sortable removed (not used); if needed, enqueue properly in PHP -->
<!-- JavaScript functionality moved to admin-settings.js for better maintainability -->




