<?php
/**
 * Admin Dashboard Template - Updated Design with License System
 * 
 * Restaurant orders dashboard interface with license restrictions
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}



$admin = new KDSAMREF_Admin();
$auto_refresh = $admin->get_setting('auto_refresh_interval', 15);
$is_pro_active = function_exists('kdsamref_is_pro_active') ? kdsamref_is_pro_active() : false;
?>


<div class="wrap kdsamref-dashboard">
    <div class="kdsamref-header">
        <div class="kdsamref-header-left">
            <div class="kdsamref-dashboard-logo">
                <svg viewBox="0 0 4019.88 1508.27" xmlns="http://www.w3.org/2000/svg">
                    <g id="Layer_2-2" data-name="Layer 2">
                        <g id="uuid-50686885-fb94-41b2-8948-3543e963754b" data-name="Layer 2-2">
                            <g id="Layer_1-2" data-name="Layer 1-2">
                                <path class="cls-1" d="M55.47,816.27c36.98-68.17,88.24-121.01,153.78-158.54,65.51-37.5,140.55-56.27,225.12-56.27,108.84,0,198.95,27.22,270.29,81.65,71.34,54.45,119.15,130.79,143.47,229.07h-239.39c-12.68-38.05-34.09-67.9-64.21-89.57-30.13-21.65-67.37-32.5-111.77-32.5-63.41,0-113.62,22.98-150.6,68.97-37.01,45.97-55.48,111.25-55.48,195.79s18.47,148.23,55.48,194.2c36.97,45.97,87.19,68.96,150.6,68.96,89.82,0,148.47-40.16,175.97-120.48h239.39c-24.33,95.12-72.41,170.69-144.26,226.7-71.88,56.02-161.7,84.01-269.49,84.01-84.57,0-159.59-18.75-225.12-56.27-65.54-37.5-116.79-90.37-153.78-158.54C18.47,1225.29,0,1145.78,0,1054.87s18.47-170.42,55.48-238.59h0Z"/>
                                <path class="cls-1" d="M1173.1,1451.99c-67.65-37.5-120.76-90.61-159.33-159.33-38.59-68.69-57.86-147.96-57.86-237.79s19.82-169.09,59.45-237.79c39.63-68.69,93.78-121.79,162.5-159.33,68.69-37.5,145.31-56.27,229.87-56.27s161.15,18.77,229.87,56.27c68.69,37.52,122.86,90.63,162.5,159.33,39.63,68.72,59.45,147.98,59.45,237.79s-20.36,169.11-61.03,237.79c-40.69,68.71-95.66,121.82-164.87,159.33-69.22,37.52-146.64,56.27-232.25,56.27s-160.66-18.75-228.29-56.27h0ZM1514.73,1285.53c35.41-19.55,63.66-48.87,84.81-87.99,21.13-39.09,31.7-86.65,31.7-142.68,0-83.48-21.95-147.68-65.79-192.61-43.87-44.91-97.5-67.37-160.9-67.37s-116.52,22.47-159.33,67.37c-42.8,44.93-64.21,109.14-64.21,192.61s20.86,147.71,62.62,192.61c41.73,44.93,94.33,67.37,157.74,67.37,40.16,0,77.93-9.76,113.34-29.33h0v.02Z"/>
                                <path class="cls-1" d="M2018.83,815.48c35.41-68.69,83.75-121.52,145.06-158.53,61.28-36.98,129.45-55.48,204.5-55.48,57.07,0,111.49,12.43,163.29,37.25,51.77,24.84,92.99,57.87,123.65,99.08V0h225.11v1494h-225.11v-130c-27.49,43.35-66.06,78.23-115.73,104.63-49.69,26.41-107.28,39.63-172.8,39.63-73.98,0-141.64-19.02-202.92-57.07-61.3-38.05-109.65-91.68-145.06-160.91-35.42-69.21-53.11-148.75-53.11-238.59s17.69-167.5,53.11-236.21h0ZM2625.21,916.15c-21.15-38.57-49.69-68.17-85.61-88.77-35.94-20.61-74.51-30.91-115.73-30.91s-79.26,10.06-114.14,30.13c-34.88,20.09-63.16,49.42-84.81,87.99-21.67,38.59-32.5,84.3-32.5,137.13s10.83,99.08,32.5,138.72c21.65,39.63,50.19,70.02,85.61,91.15,35.4,21.15,73.18,31.7,113.35,31.7s79.79-10.3,115.73-30.91c35.92-20.61,64.45-50.19,85.61-88.77,21.13-38.57,31.7-84.81,31.7-138.72s-10.58-100.12-31.7-138.72v-.02h0Z"/>
                                <path class="cls-1" d="M3907.72,1121.45h-642.05c5.28,63.41,27.47,113.1,66.59,149.02,39.08,35.94,87.19,53.91,144.26,53.91,82.44,0,141.09-35.4,175.97-106.22h239.39c-25.37,84.57-73.98,154.05-145.85,208.46-71.88,54.45-160.11,81.65-264.74,81.65-84.57,0-160.39-18.75-227.49-56.27-67.12-37.5-119.44-90.61-156.95-159.33-37.52-68.69-56.27-147.96-56.27-237.79s18.47-170.67,55.48-239.39c36.98-68.69,88.77-121.52,155.36-158.53,66.59-36.98,143.2-55.48,229.87-55.48s158.26,17.98,224.32,53.9c66.04,35.94,117.31,86.95,153.78,152.98,36.46,66.06,54.69,141.89,54.69,227.49,0,31.7-2.13,60.24-6.34,85.61h0ZM3684.19,972.43c-1.06-57.07-21.67-102.77-61.83-137.13-40.17-34.33-89.32-51.51-147.44-51.51-54.96,0-101.22,16.65-138.72,49.94-37.52,33.29-60.51,79.54-68.97,138.72h416.95Z"/>
                            </g>
                        </g>
                        <g>
                            <path class="cls-1" d="M2759.95,507.93V0h120.67v124.77l-1.7,137.38,1.7,58.64v187.14h-120.67ZM2849.95,408.39v-115.22c10.22-18.86,20.27-36.3,30.15-52.33,9.89-16.02,20.79-32.16,32.73-48.41,11.93-16.24,25.63-34.15,41.08-53.69L3067.1,0h144.53l-213.39,254.3-10.91-3.07-137.38,157.15ZM3077.32,507.93l-137.03-217.49,75.34-89.31,203.17,306.8h-141.48Z"/>
                            <path class="cls-1" d="M3380.71,514.06c-28.64,0-54.6-7.43-77.89-22.32-23.3-14.89-41.65-36.76-55.06-65.62-13.4-28.85-20.11-64.19-20.11-106.02s6.93-78.8,20.79-107.55c13.86-28.74,32.38-50.34,55.56-64.77,23.17-14.43,48.52-21.64,76.01-21.64,19.08,0,35.62,3.13,49.59,9.38,13.97,6.25,25.68,14.49,35.11,24.71,9.43,10.23,16.76,21.25,21.99,33.06h2.39V0h118.29v507.93h-116.93v-60.34h-3.41c-5.23,12.05-12.62,23.08-22.16,33.07-9.55,10-21.26,18.07-35.11,24.21-13.86,6.12-30.22,9.2-49.09,9.2ZM3419.92,421.01c15,0,27.88-4.2,38.69-12.61,10.79-8.41,19.08-20.17,24.88-35.29,5.79-15.11,8.69-32.9,8.69-53.36s-2.9-38.51-8.69-53.51c-5.8-15-14.09-26.59-24.88-34.77-10.8-8.18-23.69-12.27-38.69-12.27s-28.13,4.15-38.7,12.45c-10.56,8.29-18.58,19.95-24.03,34.94s-8.18,32.73-8.18,53.17,2.72,38.24,8.18,53.36,13.52,26.87,24.21,35.29c10.67,8.41,23.52,12.61,38.52,12.61Z"/>
                            <path class="cls-1" d="M3843.29,515.43c-32.73,0-61.71-4.72-86.92-14.15-25.23-9.42-45.62-22.95-61.19-40.57-15.57-17.61-25.28-38.69-29.14-63.23l111.47-13.3c4.09,15.68,11.69,27.68,22.84,35.97,11.13,8.29,26.48,12.44,46.02,12.44,16.35,0,29.25-2.89,38.69-8.69,9.42-5.79,14.15-13.46,14.15-23.01,0-8.4-3.75-15.28-11.25-20.62-7.5-5.34-19.08-9.49-34.77-12.45l-66.13-12.61c-37.28-7.04-65.22-19.71-83.86-38.01-18.63-18.29-27.95-41.99-27.95-71.08,0-25,6.76-46.42,20.28-64.26,13.51-17.84,32.71-31.59,57.61-41.25,24.88-9.66,54.37-14.49,88.46-14.49,32.04,0,60,4.43,83.86,13.3,23.86,8.86,42.89,21.48,57.09,37.85s23.13,35.9,26.77,58.62l-105.67,12.95c-2.96-12.72-9.66-22.77-20.12-30.16-10.46-7.38-23.63-11.08-39.54-11.08-14.54,0-26.59,2.9-36.14,8.69-9.55,5.8-14.32,13.47-14.32,23.01,0,7.73,3.12,14.44,9.37,20.12,6.25,5.68,17.1,10,32.56,12.95l72.6,13.63c37.72,7.06,65.78,18.93,84.2,35.63,18.41,16.71,27.62,38.8,27.62,66.3,0,25.69-7.56,48.08-22.68,67.16-15.11,19.08-35.91,33.92-62.38,44.48-26.48,10.55-56.98,15.85-91.53,15.85Z"/>
                        </g>
                    </g>
                </svg>
            </div>
            <h1 class="kdsamref-dashboard-title"><?php esc_html_e('Hello! Here are today\'s orders', 'kds-report-for-orderable'); ?></h1>
        </div>
        
        <div class="kdsamref-header-right">
            
            <!-- License Status Badge - Minimal -->
            <?php if (!$is_pro_active): ?>
            <div class="kdsamref-license-badge-mini kdsamref-license-free">
                <span><i class="fas fa-lock"></i></span>
                <span><?php esc_html_e('Limited', 'kds-report-for-orderable'); ?></span>
                <a href="https://codeon.ch/orderable-kds" target="_blank" rel="noopener" class="kdsamref-upgrade-btn-mini">
                    <?php esc_html_e('Upgrade to Pro', 'kds-report-for-orderable'); ?>
                </a>
            </div>
            <?php else: ?>
            <div class="kdsamref-license-badge-mini kdsamref-license-premium">
                <span>✅</span>
                <span>Premium</span>
            </div>
            <?php endif; ?>
            
            <div class="kdsamref-controls">
                <button id="kdsamref-font-decrease" class="kdsamref-font-btn" title="Decrease font size">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M5 12h14"/>
                    </svg>
                </button>
                <button id="kdsamref-font-increase" class="kdsamref-font-btn" title="Increase font size">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 5v14M5 12h14"/>
                    </svg>
                </button>
                <button id="kdsamref-refresh-btn" class="kdsamref-refresh-btn" title="Refresh">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"/>
                        <path d="M21 3v5h-5"/>
                        <path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"/>
                        <path d="M3 21v-5h5"/>
                    </svg>
                </button>
                <button id="kdsamref-search-btn" class="kdsamref-search-btn" title="Search orders">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="11" cy="11" r="8"/>
                        <path d="m21 21-4.35-4.35"/>
                    </svg>
                </button>
                <button id="kdsamref-stock-management-btn" class="kdsamref-stock-management-btn<?php echo !$is_pro_active ? ' kdsamref-pro-feature' : ''; ?>" title="<?php echo $is_pro_active ? 'Stock Management' : 'Stock Management (Pro Feature)'; ?>" data-pro-feature="stock_management">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M20 7L10 17l-5-5"/>
                        <path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"/>
                    </svg>
                    <?php if (!$is_pro_active): ?><span class="kdsamref-pro-badge">PRO</span><?php endif; ?>
                </button>
                <button id="kdsamref-notifications-btn" class="kdsamref-notifications-btn" title="Enable notifications">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"/>
                        <path d="M13.73 21a2 2 0 0 1-3.46 0"/>
                    </svg>
                    <span id="kdsamref-notification-badge" class="kdsamref-badge kdsamref-notification-badge">0</span>
                </button>

                <button id="kdsamref-dashboard-fullscreen-btn" class="kdsamref-fullscreen-btn" title="Fullscreen">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M8 3H5a2 2 0 0 0-2 2v3"/>
                        <path d="M21 8V5a2 2 0 0 0-2-2h-3"/>
                        <path d="M3 16v3a2 2 0 0 0 2 2h3"/>
                        <path d="M16 21h3a2 2 0 0 0 2-2v-3"/>
                    </svg>
                </button>
                <button id="kdsamref-masonry-toggle-btn" class="kdsamref-masonry-toggle-btn<?php echo !$is_pro_active ? ' kdsamref-pro-feature' : ''; ?>" title="<?php echo $is_pro_active ? 'Toggle masonry layout' : 'Toggle masonry layout (Pro Feature)'; ?>" data-pro-feature="masonry_layout">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M3 3h7v7H3z"/>
                        <path d="M14 3h7v7h-7z"/>
                        <path d="M14 14h7v7h-7z"/>
                        <path d="M3 14h7v7H3z"/>
                    </svg>
                    <?php if (!$is_pro_active): ?><span class="kdsamref-pro-badge">PRO</span><?php endif; ?>
                </button>
                <button id="kdsamref-header-toggle-btn" class="kdsamref-header-toggle-btn" title="Hide/Show header">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="m18 15-6-6-6 6"/>
                    </svg>
                </button>
                

            </div>
        </div>
    </div>

    <!-- Fixed Header Toggle Button (Shows when header is hidden) -->
    <button id="kdsamref-header-toggle-fixed" class="kdsamref-header-toggle-fixed" title="Show header">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <path d="m6 9 6 6 6-6"/>
        </svg>
    </button>






    <!-- Order List Header -->
    <div class="kdsamref-main-content">
        <div class="kdsamref-content-header">
            
            <!-- Status Filter Buttons -->
            <div class="kdsamref-status-filters">
                <button class="kdsamref-status-btn active" data-filter="all">
                    <span class="status-label"><?php esc_html_e('All', 'kds-report-for-orderable'); ?></span>
                    <span class="status-count" id="count-all">-</span>
                </button>
                <button class="kdsamref-status-btn" data-filter="processing">
                    <span class="status-label"><?php esc_html_e('In Progress', 'kds-report-for-orderable'); ?></span>
                    <span class="status-count" id="count-processing">-</span>
                </button>
                <button class="kdsamref-status-btn" data-filter="completed">
                    <span class="status-label"><?php esc_html_e('Completed', 'kds-report-for-orderable'); ?></span>
                    <span class="status-count" id="count-completed">-</span>
                </button>
            </div>
            
            <div class="kdsamref-header-controls">
                <div class="kdsamref-header-controls-left">
                    
                    <!-- Date Mode Switch -->
                    <div class="kdsamref-date-mode-switch">
                        <span class="kdsamref-switch-label"><?php esc_html_e('Order Date', 'kds-report-for-orderable'); ?></span>
                        <label class="kdsamref-switch">
                            <input type="checkbox" id="dateModeSwitch">
                            <span class="kdsamref-slider"></span>
                        </label>
                        <span class="kdsamref-switch-label"><?php esc_html_e('Delivery Date', 'kds-report-for-orderable'); ?></span>
                    </div>
                </div>
                
                <div class="kdsamref-header-controls-right">
                    <div class="kdsamref-date-filters">
                        <button class="kdsamref-date-btn" data-date="yesterday">Yesterday</button>
                        <button class="kdsamref-date-btn active" data-date="today">Today</button>
                        <button class="kdsamref-date-btn kdsamref-tomorrow-btn" data-date="tomorrow">Tomorrow</button>
                        
                        
                    </div>
                </div>
            </div>
        </div>

        <!-- License Info - Minimal and Dismissible -->
        <!-- For WordPress.org compliance, avoid persistent upsell bar on dashboard -->

        <!-- Search Input (Hidden by default) -->
        <div class="kdsamref-search-container" id="kdsamref-search-container">
            <input type="text" id="kdsamref-search" class="kdsamref-search-input" 
                   placeholder="Search by customer name, order number...">
        </div>

        <!-- Loading Indicator -->
        <div id="kdsamref-loading" class="kdsamref-loading">
            <div class="kdsamref-spinner"></div>
            <p><?php esc_html_e('Loading orders...', 'kds-report-for-orderable'); ?></p>
        </div>

        <!-- Orders Grid -->
        <div class="kdsamref-orders-container" id="kdsamref-orders-container">
            <!-- Orders will be loaded here via JavaScript -->
        </div>
        
        <!-- Premium Teaser Widget kaldırıldı -->

        <!-- No Orders Message -->
        <div id="kdsamref-no-orders" class="kdsamref-no-orders">
            <div class="kdsamref-empty-state">
                <h3><?php esc_html_e('No orders found', 'kds-report-for-orderable'); ?></h3>
                <p><?php esc_html_e('There are currently no orders matching your criteria.', 'kds-report-for-orderable'); ?></p>
            </div>
        </div>
    </div>
</div>

        <!-- Order Details Modal - Modern Design -->
</div>

<!-- Order Details Modal - Moved to body level for better fullscreen compatibility -->
<div id="kdsamref-order-modal" class="kdsamref-modal kdsamref-order-modal" role="dialog" aria-labelledby="order-modal-title" aria-hidden="true">
    <div class="kdsamref-modal-content kdsamref-modal-xl">
        <div class="kdsamref-modal-header">
            <h2 id="order-modal-title" class="kdsamref-modal-title">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                    <polyline points="14,2 14,8 20,8"/>
                    <line x1="16" y1="13" x2="8" y2="13"/>
                    <line x1="16" y1="17" x2="8" y2="17"/>
                    <polyline points="10,9 9,9 8,9"/>
                </svg>
                <?php esc_html_e('Order Details', 'kds-report-for-orderable'); ?>
            </h2>
            <button class="kdsamref-modal-close" aria-label="<?php esc_attr_e('Close modal', 'kds-report-for-orderable'); ?>" title="<?php esc_attr_e('Close (ESC)', 'kds-report-for-orderable'); ?>">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="18" y1="6" x2="6" y2="18"/>
                    <line x1="6" y1="6" x2="18" y2="18"/>
                </svg>
            </button>
        </div>
        <div class="kdsamref-modal-body">
            <!-- Order details will be loaded here -->
        </div>
    </div>
</div>

<!-- Stock Management Modal -->
<div id="kdsamref-stock-modal" class="kdsamref-modal kdsamref-stock-modal" role="dialog" aria-labelledby="stock-modal-title" aria-hidden="true">
    <div class="kdsamref-modal-content kdsamref-modal-xl">
        <div class="kdsamref-modal-header">
            <h2 id="stock-modal-title" class="kdsamref-modal-title">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M20 7L10 17l-5-5"/>
                    <path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"/>
                </svg>
                <?php esc_html_e('Stock Management', 'kds-report-for-orderable'); ?>
            </h2>
            <button class="kdsamref-modal-close" aria-label="<?php esc_attr_e('Close modal', 'kds-report-for-orderable'); ?>" title="<?php esc_attr_e('Close (ESC)', 'kds-report-for-orderable'); ?>">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="18" y1="6" x2="6" y2="18"/>
                    <line x1="6" y1="6" x2="18" y2="18"/>
                </svg>
            </button>
        </div>
        <div class="kdsamref-modal-body">
            <!-- Search Bar -->
            <div class="kdsamref-stock-search-container">
                <div class="kdsamref-stock-search-wrapper">
                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="kdsamref-search-icon">
                        <circle cx="11" cy="11" r="8"/>
                        <path d="m21 21-4.35-4.35"/>
                    </svg>
                    <input type="text" id="kdsamref-stock-search" class="kdsamref-stock-search-input" placeholder="Search products by name, SKU, or category...">
                    <button id="kdsamref-stock-search-clear" class="kdsamref-stock-search-clear" style="display: none;">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M18 6L6 18M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
            </div>

            <!-- Stock Filters -->
            <div class="kdsamref-stock-filters">
                <button class="kdsamref-stock-filter-btn active" data-filter="all">
                    <span class="filter-label"><?php esc_html_e('All', 'kds-report-for-orderable'); ?></span>
                    <span class="filter-count" id="stock-count-all">-</span>
                </button>
                <button class="kdsamref-stock-filter-btn" data-filter="in-stock">
                    <span class="filter-label"><?php esc_html_e('In Stock', 'kds-report-for-orderable'); ?></span>
                    <span class="filter-count" id="stock-count-in-stock">-</span>
                </button>
                <button class="kdsamref-stock-filter-btn" data-filter="low-stock">
                    <span class="filter-label"><?php esc_html_e('Low Stock', 'kds-report-for-orderable'); ?></span>
                    <span class="filter-count" id="stock-count-low-stock">-</span>
                </button>
                <button class="kdsamref-stock-filter-btn" data-filter="out-of-stock">
                    <span class="filter-label"><?php esc_html_e('Out of Stock', 'kds-report-for-orderable'); ?></span>
                    <span class="filter-count" id="stock-count-out-of-stock">-</span>
                </button>
            </div>

            <!-- Loading Indicator -->
            <div id="kdsamref-stock-loading" class="kdsamref-stock-loading">
                <div class="kdsamref-spinner"></div>
                <p><?php esc_html_e('Loading stock data...', 'kds-report-for-orderable'); ?></p>
            </div>

            <!-- Stock Items Container -->
            <div id="kdsamref-stock-container" class="kdsamref-stock-container">
                <!-- Stock items will be loaded here -->
            </div>

            <!-- No Stock Items Message -->
            <div id="kdsamref-no-stock-items" class="kdsamref-no-stock-items" style="display: none;">
                <div class="kdsamref-empty-state">
                    <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" class="kdsamref-empty-icon">
                        <path d="M20 7L10 17l-5-5"/>
                        <path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"/>
                    </svg>
                    <h3><?php esc_html_e('No Stock Items Found', 'kds-report-for-orderable'); ?></h3>
                    <p><?php esc_html_e('Try adjusting your search or filters to find what you\'re looking for.', 'kds-report-for-orderable'); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$admin = new KDSAMREF_Admin();
$dashboard_settings = $admin->get_dashboard_settings();
// License info (simplified)
$license_info = array('is_premium' => $is_pro_active);

// Get custom statuses for dynamic action buttons
$settings = $admin->get_all_settings();
$custom_statuses = $settings['custom_statuses'] ?? array();

// Include compatibility manager for mode information
        require_once KDSAMREF_PLUGIN_PATH . 'includes/class-kdsamref-compatibility-manager.php';
        $compatibility_mode = KDSAMREF_Compatibility_Manager::get_mode();
        $mode_settings = KDSAMREF_Compatibility_Manager::get_mode_settings();
?>
<?php
// Custom statuses data will be localized via the main plugin file
?>

