jQuery(document).ready(function($) {
    'use strict';
    
    // Feature card switching functionality
    $('.kdsamref-feature-card').on('click', function() {
        var feature = $(this).data('feature');
        
        // Remove active class from all cards
        $('.kdsamref-feature-card').removeClass('kdsamref-feature-card-active');
        
        // Add active class to clicked card
        $(this).addClass('kdsamref-feature-card-active');
        
        // Hide all preview cards
        $('.kdsamref-preview-card').hide();
        
        // Show selected preview card
        $('#' + feature + '-preview').fadeIn(300);
        
        // Update preview icon based on feature
        var iconClass = '';
        var iconSymbol = '';
        
        switch(feature) {
            case 'workflow':
                iconClass = 'linear-gradient(135deg, #3b82f6, #1d4ed8)';
                iconSymbol = '<i class="fas fa-cogs"></i>';
                break;
            case 'analytics':
                iconClass = 'linear-gradient(135deg, #8b5cf6, #7c3aed)';
                iconSymbol = '<i class="fas fa-chart-bar"></i>';
                break;
            case 'realtime':
                iconClass = 'linear-gradient(135deg, #10b981, #059669)';
                iconSymbol = '<i class="fas fa-sync-alt"></i>';
                break;
        }
        
        // Update preview icon
        $('.kdsamref-preview-icon').css('background', iconClass);
        $('.kdsamref-preview-symbol').html(iconSymbol);
    });
    
    // Initialize with first card active
    $('.kdsamref-feature-card:first').trigger('click');
    
    // Add hover effects for better UX
    $('.kdsamref-feature-card').hover(
        function() {
            if (!$(this).hasClass('kdsamref-feature-card-active')) {
                $(this).css('transform', 'translateY(-2px)');
            }
        },
        function() {
            if (!$(this).hasClass('kdsamref-feature-card-active')) {
                $(this).css('transform', 'translateY(0)');
            }
        }
    );
    
    // Add smooth scrolling for better navigation
    $('a[href^="#"]').on('click', function(event) {
        var target = $(this.getAttribute('href'));
        if (target.length) {
            event.preventDefault();
            $('html, body').stop().animate({
                scrollTop: target.offset().top - 100
            }, 1000);
        }
    });
    
    // Add animation to stats in real-time preview
    function animateStats() {
        $('.kdsamref-stat-value').each(function() {
            var $this = $(this);
            var countTo = parseInt($this.text());
            
            $({ countNum: 0 }).animate({
                countNum: countTo
            }, {
                duration: 2000,
                easing: 'swing',
                step: function() {
                    $this.text(Math.floor(this.countNum));
                },
                complete: function() {
                    $this.text(this.countNum);
                }
            });
        });
    }
    
    // Trigger stats animation when real-time preview is shown
    $(document).on('click', '.kdsamref-feature-card[data-feature="realtime"]', function() {
        setTimeout(animateStats, 500);
    });
    
    // Add loading animation for chart bars
    function animateChartBars() {
        $('.kdsamref-bar').each(function(index) {
            var $bar = $(this);
            var height = $bar.css('height');
            
            $bar.css('height', '0%');
            
            setTimeout(function() {
                $bar.animate({
                    height: height
                }, 1000 + (index * 200), 'swing');
            }, index * 100);
        });
    }
    
    // Trigger chart animation when analytics preview is shown
    $(document).on('click', '.kdsamref-feature-card[data-feature="analytics"]', function() {
        setTimeout(animateChartBars, 500);
    });
    
    // Add pulse animation to real-time indicator
    function startPulseAnimation() {
        $('.kdsamref-pulse-dot').addClass('pulse-animation');
    }
    
    // Trigger pulse animation when real-time preview is shown
    $(document).on('click', '.kdsamref-feature-card[data-feature="realtime"]', function() {
        setTimeout(startPulseAnimation, 500);
    });
    
    // Add intersection observer for scroll animations
    if ('IntersectionObserver' in window) {
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('animate-in');
                }
            });
        }, {
            threshold: 0.1
        });
        
        // Observe feature cards and preview cards
        document.querySelectorAll('.kdsamref-feature-card, .kdsamref-preview-card').forEach(el => {
            observer.observe(el);
        });
    }
});
